/*
 * Decompiled with CFR 0.152.
 */
public class DessinBitmapEnConsole {
    public static void saisie(String string, Couleur couleur) {
        Console.afficherln(string);
        Console.afficher("Rouge : ");
        couleur.r = Console.saisirInt();
        Console.afficher("Vert  : ");
        couleur.v = Console.saisirInt();
        Console.afficher("Bleu  : ");
        couleur.b = Console.saisirInt();
    }

    public static void saisie(String string, Position2D position2D) {
        Console.afficherln(string);
        Console.afficher("x : ");
        position2D.x = Console.saisirInt();
        Console.afficher("y : ");
        position2D.y = Console.saisirInt();
    }

    public static void saisie(String string, Pixel pixel) {
        Console.afficherln(string);
        DessinBitmapEnConsole.saisie("Position", pixel.pos);
    }

    public static void saisie(String string, Segment2D segment2D) {
        Console.afficherln(string);
        DessinBitmapEnConsole.saisie("Sommet initial", segment2D.si);
        DessinBitmapEnConsole.saisie("Sommet final", segment2D.sf);
    }

    public static void saisie(String string, Rectangle2D rectangle2D) {
        Console.afficherln(string);
        DessinBitmapEnConsole.saisie("Centre", rectangle2D.c);
        Console.afficher("Largeur  : ");
        rectangle2D.tx = Console.saisirInt();
        Console.afficher("Hauteur  : ");
        rectangle2D.ty = Console.saisirInt();
        Console.afficher("Rotation : ");
        rectangle2D.rot = Console.saisirDouble();
    }

    public static void saisie(String string, Cercle2D cercle2D) {
        Console.afficherln(string);
        DessinBitmapEnConsole.saisie("Centre", cercle2D.c);
        Console.afficher("Rayon : ");
        cercle2D.r = Console.saisirDouble();
    }

    public static void saisie(String string, Ellipse2D ellipse2D) {
        Console.afficherln(string);
        DessinBitmapEnConsole.saisie("Centre", ellipse2D.c);
        Console.afficher("Largeur  : ");
        ellipse2D.a = Console.saisirInt();
        Console.afficher("Hauteur  : ");
        ellipse2D.b = Console.saisirInt();
        Console.afficher("Rotation : ");
        ellipse2D.rot = Console.saisirDouble();
    }

    public static void saisie(String string, PolygoneRegulier2D polygoneRegulier2D) {
        Console.afficherln(string);
        DessinBitmapEnConsole.saisie("Centre", polygoneRegulier2D.c);
        Console.afficher("Rayon          : ");
        polygoneRegulier2D.r = Console.saisirDouble();
        Console.afficher("Nombre sommets : ");
        polygoneRegulier2D.n = Console.saisirInt();
        Console.afficher("Rotation       : ");
        polygoneRegulier2D.rot = Console.saisirDouble();
    }

    public static Position2D positionAvecRotation(Position2D position2D, double d, double d2, double d3) {
        Position2D position2D2 = new Position2D();
        position2D2.x = position2D.x + d * Math.cos(d3) - d2 * Math.sin(d3);
        position2D2.y = position2D.y + d * Math.sin(d3) + d2 * Math.cos(d3);
        return position2D2;
    }

    public static Position2D[] sommets(Rectangle2D rectangle2D) {
        Position2D[] position2DArray = new Position2D[]{DessinBitmapEnConsole.positionAvecRotation(rectangle2D.c, rectangle2D.tx / 2.0, rectangle2D.ty / 2.0, rectangle2D.rot), DessinBitmapEnConsole.positionAvecRotation(rectangle2D.c, -rectangle2D.tx / 2.0, rectangle2D.ty / 2.0, rectangle2D.rot), DessinBitmapEnConsole.positionAvecRotation(rectangle2D.c, -rectangle2D.tx / 2.0, -rectangle2D.ty / 2.0, rectangle2D.rot), DessinBitmapEnConsole.positionAvecRotation(rectangle2D.c, rectangle2D.tx / 2.0, -rectangle2D.ty / 2.0, rectangle2D.rot)};
        return position2DArray;
    }

    public static Position2D[] sommets(Cercle2D cercle2D, int n) {
        Position2D[] position2DArray = new Position2D[n];
        for (int i = 0; i < n; ++i) {
            double d = (double)i * 2.0 * Math.PI / (double)n;
            position2DArray[i] = new Position2D();
            position2DArray[i].x = cercle2D.c.x + cercle2D.r * Math.cos(d);
            position2DArray[i].y = cercle2D.c.y + cercle2D.r * Math.sin(d);
        }
        return position2DArray;
    }

    public static Position2D[] sommets(Ellipse2D ellipse2D, int n) {
        Position2D[] position2DArray = new Position2D[n];
        for (int i = 0; i < n; ++i) {
            double d = (double)i * 2.0 * Math.PI / (double)n;
            position2DArray[i] = DessinBitmapEnConsole.positionAvecRotation(ellipse2D.c, ellipse2D.a * Math.cos(d), ellipse2D.b * Math.sin(d), ellipse2D.rot);
        }
        return position2DArray;
    }

    public static Position2D[] sommets(PolygoneRegulier2D polygoneRegulier2D) {
        Position2D[] position2DArray = new Position2D[polygoneRegulier2D.n];
        for (int i = 0; i < polygoneRegulier2D.n; ++i) {
            double d = (double)i * 2.0 * Math.PI / (double)polygoneRegulier2D.n;
            position2DArray[i] = DessinBitmapEnConsole.positionAvecRotation(polygoneRegulier2D.c, polygoneRegulier2D.r * Math.cos(d), polygoneRegulier2D.r * Math.sin(d), polygoneRegulier2D.rot);
        }
        return position2DArray;
    }

    public static void affichageTableauSommets(Position2D[] position2DArray) {
        for (int i = 0; i < position2DArray.length; ++i) {
            EcranGraphique.drawLine((int)position2DArray[i].x, (int)position2DArray[i].y, (int)position2DArray[(i + 1) % position2DArray.length].x, (int)position2DArray[(i + 1) % position2DArray.length].y);
        }
    }

    public static void affichageGraphique(Pixel pixel, Couleur couleur) {
        EcranGraphique.setColor(couleur.r, couleur.v, couleur.b);
        EcranGraphique.drawPixel((int)pixel.pos.x, (int)pixel.pos.y);
    }

    public static void affichageGraphique(Segment2D segment2D, Couleur couleur) {
        EcranGraphique.setColor(couleur.r, couleur.v, couleur.b);
        EcranGraphique.drawLine((int)segment2D.si.x, (int)segment2D.si.y, (int)segment2D.sf.x, (int)segment2D.sf.y);
    }

    public static void affichageGraphique(Rectangle2D rectangle2D, Couleur couleur) {
        EcranGraphique.setColor(couleur.r, couleur.v, couleur.b);
        DessinBitmapEnConsole.affichageTableauSommets(DessinBitmapEnConsole.sommets(rectangle2D));
    }

    public static void affichageGraphique(Cercle2D cercle2D, Couleur couleur) {
        EcranGraphique.setColor(couleur.r, couleur.v, couleur.b);
        DessinBitmapEnConsole.affichageTableauSommets(DessinBitmapEnConsole.sommets(cercle2D, 180));
    }

    public static void affichageGraphique(Ellipse2D ellipse2D, Couleur couleur) {
        EcranGraphique.setColor(couleur.r, couleur.v, couleur.b);
        DessinBitmapEnConsole.affichageTableauSommets(DessinBitmapEnConsole.sommets(ellipse2D, 180));
    }

    public static void affichageGraphique(PolygoneRegulier2D polygoneRegulier2D, Couleur couleur) {
        EcranGraphique.setColor(couleur.r, couleur.v, couleur.b);
        DessinBitmapEnConsole.affichageTableauSommets(DessinBitmapEnConsole.sommets(polygoneRegulier2D));
    }

    public static void croix(int n, int n2, Cercle2D cercle2D, Couleur couleur) {
        EcranGraphique.setColor(couleur.r, couleur.v, couleur.b);
        EcranGraphique.drawLine(n - 10, n2, n + 10, n2);
        EcranGraphique.drawLine(n, n2 - 10, n, n2 + 10);
        DessinBitmapEnConsole.affichageGraphique(cercle2D, couleur);
    }

    public static void saisieInteractiveSouris(Cercle2D cercle2D) {
        while (EcranGraphique.getMouseState() == 0) {
        }
        EcranGraphique.setXorMode(true);
        int n = EcranGraphique.getMouseX();
        int n2 = EcranGraphique.getMouseY();
        Couleur couleur = new Couleur();
        couleur.r = 255;
        couleur.v = 255;
        couleur.b = 255;
        cercle2D.c.x = n;
        cercle2D.c.y = n2;
        cercle2D.r = 0.0;
        DessinBitmapEnConsole.croix(n, n2, cercle2D, couleur);
        while (EcranGraphique.getMouseState() == 1) {
            int n3 = EcranGraphique.getMouseX();
            int n4 = EcranGraphique.getMouseY();
            if (n3 == n && n4 == n2) continue;
            DessinBitmapEnConsole.croix(n, n2, cercle2D, couleur);
            n = n3;
            n2 = n4;
            cercle2D.r = Math.sqrt(Math.pow((double)n3 - cercle2D.c.x, 2.0) + Math.pow((double)n4 - cercle2D.c.y, 2.0));
            DessinBitmapEnConsole.croix(n3, n4, cercle2D, couleur);
            EcranGraphique.flush();
        }
        DessinBitmapEnConsole.croix(n, n2, cercle2D, couleur);
        EcranGraphique.flush();
        EcranGraphique.setXorMode(false);
    }

    public static int resultatMenuPrincipal() {
        Console.sautDeLigne();
        Console.afficherln(" 1: Choix de la couleur de trace");
        Console.afficherln(" 2: Afficher un pixel");
        Console.afficherln(" 3: Afficher un segment de droite");
        Console.afficherln(" 4: Afficher un rectangle");
        Console.afficherln(" 5: Afficher un cercle");
        Console.afficherln(" 6: Afficher une ellipse");
        Console.afficherln(" 7: Afficher un polygone regulier");
        Console.afficherln(" 8: Afficher n objets tires au hasard");
        Console.afficherln(" 9: Choisir la couleur d'effacement de la fenetre");
        Console.afficherln("10: Effacer la fenetre");
        Console.afficherln("11: Tracer dynamiquement un cercle");
        Console.afficherln(" 0: Quitter");
        Console.afficher("Que voulez vous faire ? ");
        int n = Console.saisirInt();
        Console.sautDeLigne();
        return n;
    }

    public static void main(String[] stringArray) {
        Console.setTitle("DessinBitmap");
        Pixel pixel = new Pixel();
        Segment2D segment2D = new Segment2D();
        Rectangle2D rectangle2D = new Rectangle2D();
        Cercle2D cercle2D = new Cercle2D();
        Ellipse2D ellipse2D = new Ellipse2D();
        PolygoneRegulier2D polygoneRegulier2D = new PolygoneRegulier2D();
        Couleur couleur = new Couleur();
        couleur.r = 0;
        couleur.v = 0;
        couleur.b = 0;
        Couleur couleur2 = new Couleur();
        couleur2.r = 255;
        couleur2.v = 255;
        couleur2.b = 255;
        Console.afficherln("Taille de la fenetre");
        Console.afficher("Tx : ");
        int n = Console.saisirInt();
        Console.afficher("Ty : ");
        int n2 = Console.saisirInt();
        EcranGraphique.init(50, 50, n, n2, n - 40, n2 - 80, "Dessin bitmap");
        EcranGraphique.setClearColor(255, 255, 255);
        EcranGraphique.clear();
        EcranGraphique.flush();
        int n3 = DessinBitmapEnConsole.resultatMenuPrincipal();
        while (n3 != 0) {
            switch (n3) {
                case 1: {
                    DessinBitmapEnConsole.saisie("Couleur de trace?", couleur);
                    break;
                }
                case 2: {
                    DessinBitmapEnConsole.saisie("Votre pixel?", pixel);
                    DessinBitmapEnConsole.affichageGraphique(pixel, couleur);
                    EcranGraphique.flush();
                    break;
                }
                case 3: {
                    DessinBitmapEnConsole.saisie("Votre segment?", segment2D);
                    DessinBitmapEnConsole.affichageGraphique(segment2D, couleur);
                    EcranGraphique.flush();
                    break;
                }
                case 4: {
                    DessinBitmapEnConsole.saisie("Votre rectangle?", rectangle2D);
                    DessinBitmapEnConsole.affichageGraphique(rectangle2D, couleur);
                    EcranGraphique.flush();
                    break;
                }
                case 5: {
                    DessinBitmapEnConsole.saisie("Votre cercle?", cercle2D);
                    DessinBitmapEnConsole.affichageGraphique(cercle2D, couleur);
                    EcranGraphique.flush();
                    break;
                }
                case 6: {
                    DessinBitmapEnConsole.saisie("Votre ellipse?", ellipse2D);
                    DessinBitmapEnConsole.affichageGraphique(ellipse2D, couleur);
                    EcranGraphique.flush();
                    break;
                }
                case 7: {
                    DessinBitmapEnConsole.saisie("Votre polygone regulier?", polygoneRegulier2D);
                    DessinBitmapEnConsole.affichageGraphique(polygoneRegulier2D, couleur);
                    EcranGraphique.flush();
                    break;
                }
                case 8: {
                    Console.afficher("Nombre d'objets : ");
                    int n4 = Console.saisirInt();
                    block22: for (int i = 0; i < n4; ++i) {
                        int n5 = (int)(Math.random() * 6.0);
                        switch (n5) {
                            case 0: {
                                pixel.pos.x = Math.random() * (double)n;
                                pixel.pos.y = Math.random() * (double)n2;
                                DessinBitmapEnConsole.affichageGraphique(pixel, couleur);
                                continue block22;
                            }
                            case 1: {
                                segment2D.si.x = Math.random() * (double)n;
                                segment2D.si.y = Math.random() * (double)n2;
                                segment2D.sf.x = Math.random() * (double)n;
                                segment2D.sf.y = Math.random() * (double)n2;
                                DessinBitmapEnConsole.affichageGraphique(segment2D, couleur);
                                continue block22;
                            }
                            case 2: {
                                rectangle2D.c.x = Math.random() * (double)n;
                                rectangle2D.c.y = Math.random() * (double)n2;
                                rectangle2D.tx = 3.0 + Math.random() * 500.0;
                                rectangle2D.ty = 3.0 + Math.random() * 500.0;
                                rectangle2D.rot = Math.random() * 2.0 * Math.PI;
                                DessinBitmapEnConsole.affichageGraphique(rectangle2D, couleur);
                                continue block22;
                            }
                            case 3: {
                                cercle2D.c.x = Math.random() * (double)n;
                                cercle2D.c.y = Math.random() * (double)n2;
                                cercle2D.r = 3.0 + Math.random() * 200.0;
                                DessinBitmapEnConsole.affichageGraphique(cercle2D, couleur);
                                continue block22;
                            }
                            case 4: {
                                ellipse2D.c.x = Math.random() * (double)n;
                                ellipse2D.c.y = Math.random() * (double)n2;
                                ellipse2D.a = 3.0 + Math.random() * 200.0;
                                ellipse2D.b = 3.0 + Math.random() * 200.0;
                                ellipse2D.rot = Math.random() * 2.0 * Math.PI;
                                DessinBitmapEnConsole.affichageGraphique(ellipse2D, couleur);
                                continue block22;
                            }
                            case 5: {
                                polygoneRegulier2D.c.x = Math.random() * (double)n;
                                polygoneRegulier2D.c.y = Math.random() * (double)n2;
                                polygoneRegulier2D.n = 3 + (int)(Math.random() * 10.0);
                                polygoneRegulier2D.r = 3.0 + Math.random() * 200.0;
                                polygoneRegulier2D.rot = Math.random() * 2.0 * Math.PI;
                                DessinBitmapEnConsole.affichageGraphique(polygoneRegulier2D, couleur);
                            }
                        }
                    }
                    EcranGraphique.flush();
                    break;
                }
                case 9: {
                    DessinBitmapEnConsole.saisie("Couleur d'effacement?", couleur2);
                    break;
                }
                case 10: {
                    EcranGraphique.setClearColor(couleur2.r, couleur2.v, couleur2.b);
                    EcranGraphique.clear();
                    EcranGraphique.flush();
                    break;
                }
                case 11: {
                    DessinBitmapEnConsole.saisieInteractiveSouris(cercle2D);
                    DessinBitmapEnConsole.affichageGraphique(cercle2D, couleur);
                    EcranGraphique.flush();
                }
            }
            n3 = DessinBitmapEnConsole.resultatMenuPrincipal();
        }
        Console.afficherln("Return pour quitter");
        Console.saisirString();
        EcranGraphique.exit();
    }

    public static class PolygoneRegulier2D {
        public Position2D c = new Position2D();
        public int n = 3;
        public double r = 1.0;
        public double rot = 0.0;
    }

    public static class Ellipse2D {
        public Position2D c = new Position2D();
        public double a = 1.0;
        public double b = 1.0;
        public double rot = 0.0;
    }

    public static class Cercle2D {
        public Position2D c = new Position2D();
        public double r = 1.0;
    }

    public static class Rectangle2D {
        public Position2D c = new Position2D();
        public double tx = 1.0;
        public double ty = 1.0;
        public double rot = 0.0;
    }

    public static class Segment2D {
        public Position2D si = new Position2D();
        public Position2D sf = new Position2D();
    }

    public static class Pixel {
        public Position2D pos = new Position2D();
    }

    public static class Position2D {
        public double x = 0.0;
        public double y = 0.0;
    }

    public static class Couleur {
        public int r = 0;
        public int v = 0;
        public int b = 0;
    }
}

