/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;

public class CanvasConsole
extends Canvas
implements Printable {
    public static boolean open = false;
    public Vector<String> lignes = new Vector();
    public int maxl;
    public int lc;
    private CurseurCanvasConsole ccc;
    public boolean curseur = true;
    private FrameConsole fc;
    private boolean top = true;
    private int size;
    private Font font;
    private int width;
    private int height;
    private String defaultFont = "Courier new";
    private int defaultSize = 18;
    private int defaultStyle = 1;
    private boolean c = false;
    private int cpxi;
    private int cpxf;
    private int cpy;
    private int oldDeb = 0;

    public CanvasConsole(FrameConsole frameConsole, int n) {
        this.maxl = n;
        this.fc = frameConsole;
        this.size = this.defaultSize;
        this.font = new Font(this.defaultFont, this.defaultStyle, this.defaultSize);
        this.lc = 0;
        this.lignes.add("");
        this.ccc = new CurseurCanvasConsole(this, 700);
        this.ccc.start();
    }

    public void effacer() {
        this.lc = 0;
        this.lignes = new Vector();
        this.lignes.add("");
    }

    public void sauve(PrintWriter printWriter) {
        for (int i = 0; i <= this.lc; ++i) {
            printWriter.println(this.lignes.elementAt(i));
        }
    }

    public void print(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() == 1 && string2.charAt(0) == '\n') {
                string2 = new String("");
                this.lignes.add(string2);
                ++this.lc;
                continue;
            }
            String string3 = this.format(this.lignes.elementAt(this.lc));
            string3 = string3.concat(string2);
            this.lignes.setElementAt(string3, this.lc);
        }
        this.top = true;
        this.repaint();
    }

    public String format(String string) {
        return string;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        Insets insets = this.fc.getInsets();
        Insets insets2 = this.fc.sp.getInsets();
        int n2 = graphics.getFontMetrics().getHeight() + 6;
        n2 = this.defaultSize + 4;
        this.setSize(this.fc.sp.getViewportSize().width, this.maxl * n2 + 5);
        this.fc.validate();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(this.font);
        int n3 = n = this.lc + 1 > this.maxl ? this.lc - this.maxl + 1 : 0;
        if (n != this.oldDeb) {
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, this.fc.sp.getViewportSize().width, this.maxl * n2 + 5);
            this.oldDeb = n;
        }
        graphics2D.setColor(Color.black);
        for (int i = n; i <= this.lc; ++i) {
            graphics2D.drawString(this.format(this.lignes.elementAt(i)), 4, 13 + (i - n) * n2);
        }
        String string = this.format(this.lignes.elementAt(this.lc));
        int n4 = 0;
        if (Console.line != null) {
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(4 + graphics.getFontMetrics().stringWidth(string), 13 + (this.lc - n) * n2 - n2, this.getWidth(), n2);
            graphics2D.setColor(Color.black);
            graphics2D.drawString(Console.line, 4 + graphics.getFontMetrics().stringWidth(string), 13 + (this.lc - n) * n2);
            n4 = Console.line.length();
        }
        int n5 = 4 + graphics.getFontMetrics().stringWidth(string) + (Console.line != null ? graphics.getFontMetrics().stringWidth(Console.line) : 0);
        if (this.curseur) {
            if (this.c) {
                graphics2D.setColor(Color.white);
                graphics2D.drawLine(this.cpxi, this.cpy, this.cpxf, this.cpy);
            }
            graphics2D.setColor(Color.black);
            this.c = true;
            this.cpxi = n5;
            this.cpy = 13 + (this.lc - n) * n2;
            this.cpxf = n5 + (this.size / 2 + 1);
            graphics2D.drawLine(this.cpxi, this.cpy, this.cpxf, 13 + (this.lc - n) * n2);
        } else {
            if (this.c) {
                graphics2D.setColor(Color.white);
                graphics2D.drawLine(this.cpxi, this.cpy, this.cpxf, this.cpy);
            }
            graphics2D.setColor(Color.white);
            this.c = false;
            this.cpxi = n5;
            this.cpy = 13 + (this.lc - n) * n2;
            this.cpxf = n5 + (this.size / 2 + 1);
            graphics2D.drawLine(this.cpxi, this.cpy, this.cpxf, 13 + (this.lc - n) * n2);
        }
        graphics2D.setColor(Color.black);
        if (this.top) {
            if (this.lc < this.fc.sp.getViewportSize().height / n2 - 1) {
                this.fc.sp.setScrollPosition(0, 0);
            } else {
                this.fc.sp.setScrollPosition(0, (this.lc + 1 - this.fc.sp.getViewportSize().height / n2) * n2);
            }
            this.top = false;
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Font font = new Font("Courier", 0, this.size);
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = new FontRenderContext(graphics2D.getTransform(), false, false);
        Rectangle2D rectangle2D = font.getStringBounds("AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA", fontRenderContext);
        this.width = (int)(pageFormat.getImageableWidth() / rectangle2D.getWidth() * 100.0);
        this.height = (int)(pageFormat.getImageableHeight() / (double)this.size);
        if (n * this.height > this.lc + 1) {
            return 1;
        }
        int n2 = (int)pageFormat.getImageableX();
        int n3 = (int)pageFormat.getImageableY();
        boolean bl = false;
        int n4 = n * this.height;
        int n5 = (n + 1) * this.height - 1;
        if (n5 > this.lc) {
            n5 = this.lc;
        }
        for (int i = n4; i <= n5; ++i) {
            graphics2D.drawString(this.format(this.lignes.elementAt(i)), n2, n3 + (i - n4 + 1) * this.size);
        }
        return 0;
    }
}

