/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;

public class TraitementImageEnConsole {
    public static int resultatExecutionMenu() {
        Console.sautDeLigne();
        Console.afficherln("1: Charger une image depuis raphaello.univ-fcomte.fr");
        Console.afficherln("2: Charger une image depuis 127.0.0.1");
        Console.afficherln("3: Diminuer la luminosite de l'image");
        Console.afficherln("4: Augmenter la luminosite de l'image");
        Console.afficherln("5: Diminuer le contraste de l'image");
        Console.afficherln("6: Augmenter le contraste de l'image");
        Console.afficherln("7: Flouter l'image");
        Console.afficherln("8: Extraire les contours de l'image");
        Console.afficherln("0: Quitter");
        Console.afficher("Que voulez vous faire ? ");
        int n = Console.saisirInt();
        Console.sautDeLigne();
        return n;
    }

    public static int[][] chargeImage(String string) {
        BufferedImage bufferedImage = null;
        try {
            URL uRL = new URL(string);
            bufferedImage = ImageIO.read(uRL);
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (bufferedImage.getWidth() == 0) {
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int[] nArray = new int[n * n2 * 3];
        nArray = bufferedImage.getRaster().getPixels(0, 0, n, n2, nArray);
        int[][] nArray2 = new int[n][n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray2[j][i] = nArray[n3] + nArray[n3 + 1] * 256 + nArray[n3 + 2] * 65536;
                n3 += 3;
            }
        }
        return nArray2;
    }

    public static int couleur(int n, int n2, int n3) {
        int n4 = n3 * 256 * 256 + n2 * 256 + n;
        return n4;
    }

    static void diminuerLuminosite(int[][] nArray, double d) {
        double d2 = 1.0 - d / 100.0;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[0].length; ++j) {
                int n = nArray[i][j] % 256;
                int n2 = nArray[i][j] / 256 % 256;
                int n3 = nArray[i][j] / 65536;
                n = (int)((double)n * d2);
                n2 = (int)((double)n2 * d2);
                n3 = (int)((double)n3 * d2);
                nArray[i][j] = TraitementImageEnConsole.couleur(n, n2, n3);
            }
        }
    }

    static void augmenterLuminosite(int[][] nArray, double d) {
        double d2 = 1.0 - d / 100.0;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[0].length; ++j) {
                int n = nArray[i][j] % 256;
                int n2 = nArray[i][j] / 256 % 256;
                int n3 = nArray[i][j] / 65536;
                n = 255 - (int)((double)(255 - n) * d2);
                n2 = 255 - (int)((double)(255 - n2) * d2);
                n3 = 255 - (int)((double)(255 - n3) * d2);
                nArray[i][j] = TraitementImageEnConsole.couleur(n, n2, n3);
            }
        }
    }

    static void diminuerContraste(int[][] nArray, double d) {
        double d2 = 1.0 - d / 100.0;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[0].length; ++j) {
                int n = nArray[i][j] % 256;
                int n2 = nArray[i][j] / 256 % 256;
                int n3 = nArray[i][j] / 65536;
                n = 127 - (int)((double)(127 - n) * d2);
                n2 = 127 - (int)((double)(127 - n2) * d2);
                n3 = 127 - (int)((double)(127 - n3) * d2);
                nArray[i][j] = TraitementImageEnConsole.couleur(n, n2, n3);
            }
        }
    }

    static void augmenterContraste(int[][] nArray, double d) {
        double d2 = 1.0 - d / 100.0;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[0].length; ++j) {
                int n = nArray[i][j] % 256;
                int n2 = nArray[i][j] / 256 % 256;
                int n3 = nArray[i][j] / 65536;
                n = n <= 127 ? (int)((double)n * d2) : 255 - (int)((double)(255 - n) * d2);
                n2 = n2 <= 127 ? (int)((double)n2 * d2) : 255 - (int)((double)(255 - n2) * d2);
                n3 = n3 <= 127 ? (int)((double)n3 * d2) : 255 - (int)((double)(255 - n3) * d2);
                nArray[i][j] = TraitementImageEnConsole.couleur(n, n2, n3);
            }
        }
    }

    static int[][] clone(int[][] nArray) {
        int n = nArray.length;
        int n2 = nArray[0].length;
        int[][] nArray2 = new int[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                nArray2[i][j] = nArray[i][j];
            }
        }
        return nArray2;
    }

    static void flouter(int[][] nArray) {
        int[][] nArray2 = TraitementImageEnConsole.clone(nArray);
        for (int i = 0; i < nArray2.length; ++i) {
            for (int j = 0; j < nArray2[0].length; ++j) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                for (int k = i - 2; k <= i + 2; ++k) {
                    for (int i2 = j - 2; i2 <= j + 2; ++i2) {
                        if (k < 0 || k >= nArray2.length || i2 < 0 || i2 >= nArray2[0].length) continue;
                        n += nArray2[k][i2] % 256;
                        n2 += nArray2[k][i2] / 256 % 256;
                        n3 += nArray2[k][i2] / 65536;
                        ++n4;
                    }
                }
                int n5 = n / n4;
                int n6 = n2 / n4;
                int n7 = n3 / n4;
                nArray[i][j] = TraitementImageEnConsole.couleur(n5, n6, n7);
            }
        }
    }

    static void extraireContours(int[][] nArray) {
        int n;
        int[][] nArray2 = TraitementImageEnConsole.clone(nArray);
        for (n = 0; n < nArray2.length; ++n) {
            nArray[n][0] = 0;
            nArray[n][nArray[0].length - 1] = 0;
        }
        for (n = 1; n < nArray2[0].length - 1; ++n) {
            nArray[0][n] = 0;
            nArray[nArray.length - 1][n] = 0;
        }
        for (n = 1; n < nArray2.length - 1; ++n) {
            for (int i = 1; i < nArray2[0].length - 1; ++i) {
                int n2 = 4 * (nArray2[n][i] % 256);
                int n3 = 4 * (nArray2[n][i] / 256 % 256);
                int n4 = 4 * (nArray2[n][i] / 65536);
                n2 -= nArray2[n - 1][i] % 256;
                n3 -= nArray2[n - 1][i] / 256 % 256;
                n4 -= nArray2[n - 1][i] / 65536;
                n2 -= nArray2[n + 1][i] % 256;
                n3 -= nArray2[n + 1][i] / 256 % 256;
                n4 -= nArray2[n + 1][i] / 65536;
                n2 -= nArray2[n][i - 1] % 256;
                n3 -= nArray2[n][i - 1] / 256 % 256;
                n4 -= nArray2[n][i - 1] / 65536;
                n2 -= nArray2[n][i + 1] % 256;
                n3 -= nArray2[n][i + 1] / 256 % 256;
                n4 -= nArray2[n][i + 1] / 65536;
                if ((n2 = Math.abs(n2)) > 255) {
                    n2 = 255;
                }
                if ((n3 = Math.abs(n3)) > 255) {
                    n3 = 255;
                }
                if ((n4 = Math.abs(n4)) > 255) {
                    n4 = 255;
                }
                nArray[n][i] = TraitementImageEnConsole.couleur(n2, n3, n4);
            }
        }
    }

    public static void main(String[] stringArray) {
        Console.setTitle("TraitementImage");
        int[][] nArray = new int[640][480];
        EcranGraphique.init(50, 50, 900, 700, 800, 600, "Traitement d'images");
        int n = TraitementImageEnConsole.resultatExecutionMenu();
        while (n != 0) {
            switch (n) {
                case 1: {
                    String string = "http://raphaello.univ-fcomte.fr/Algo-S2/06-Matrices/Image.jpg";
                    nArray = TraitementImageEnConsole.chargeImage(string);
                    int n2 = nArray.length;
                    int n3 = nArray[0].length;
                    EcranGraphique.drawImage(0, 0, nArray);
                    EcranGraphique.flush();
                    break;
                }
                case 2: {
                    String string = "http://127.0.0.1:9000/Algo-S2/06-Matrices/Image.jpg";
                    nArray = TraitementImageEnConsole.chargeImage(string);
                    int n2 = nArray.length;
                    int n3 = nArray[0].length;
                    EcranGraphique.drawImage(0, 0, nArray);
                    EcranGraphique.flush();
                    break;
                }
                case 3: {
                    Console.afficher("Diminution de luminosit\u00e9. De combien de % ? ");
                    double d = Console.saisirDouble();
                    TraitementImageEnConsole.diminuerLuminosite(nArray, d);
                    EcranGraphique.drawImage(0, 0, nArray);
                    EcranGraphique.flush();
                    break;
                }
                case 4: {
                    Console.afficher("Augmentation de luminosit\u00e9. De combien de % ? ");
                    double d = Console.saisirDouble();
                    TraitementImageEnConsole.augmenterLuminosite(nArray, d);
                    EcranGraphique.drawImage(0, 0, nArray);
                    EcranGraphique.flush();
                    break;
                }
                case 5: {
                    Console.afficher("Diminution du contraste. De combien de % ? ");
                    double d = Console.saisirDouble();
                    TraitementImageEnConsole.diminuerContraste(nArray, d);
                    EcranGraphique.drawImage(0, 0, nArray);
                    EcranGraphique.flush();
                    break;
                }
                case 6: {
                    Console.afficher("Augmentation du contraste. De combien de % ? ");
                    double d = Console.saisirDouble();
                    TraitementImageEnConsole.augmenterContraste(nArray, d);
                    EcranGraphique.drawImage(0, 0, nArray);
                    EcranGraphique.flush();
                    break;
                }
                case 7: {
                    TraitementImageEnConsole.flouter(nArray);
                    EcranGraphique.drawImage(0, 0, nArray);
                    EcranGraphique.flush();
                    break;
                }
                case 8: {
                    TraitementImageEnConsole.extraireContours(nArray);
                    EcranGraphique.drawImage(0, 0, nArray);
                    EcranGraphique.flush();
                }
            }
            n = TraitementImageEnConsole.resultatExecutionMenu();
        }
        EcranGraphique.exit();
    }
}

