/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;

public class CanvasConsole
extends Canvas
implements Printable {
    public static boolean open = false;
    public Vector lignes;
    public int maxl;
    public int lc;
    private Font font = new Font("Courier", 0, 12);
    private CurseurCanvasConsole ccc;
    public boolean curseur = true;
    private FrameConsole fc;
    private boolean top = true;
    private int size = 12;
    private int width;
    private int height;

    public CanvasConsole(FrameConsole frameConsole, int n) {
        this.lignes = new Vector();
        this.maxl = n;
        this.fc = frameConsole;
        this.lc = 0;
        this.lignes.add("");
        this.ccc = new CurseurCanvasConsole(this, 700);
        this.ccc.start();
    }

    public void effacer() {
        this.lc = 0;
        this.lignes = new Vector();
        this.lignes.add("");
    }

    public void sauve(PrintWriter printWriter) {
        for (int i = 0; i <= this.lc; ++i) {
            printWriter.println((String)this.lignes.elementAt(i));
        }
    }

    public void print(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() == 1 && string2.charAt(0) == '\n') {
                string2 = new String("");
                this.lignes.add(string2);
                ++this.lc;
                continue;
            }
            String string3 = this.format((String)this.lignes.elementAt(this.lc));
            string3 = string3.concat(string2);
            this.lignes.setElementAt(string3, this.lc);
        }
        this.top = true;
        this.repaint();
    }

    public String format(String string) {
        return string;
    }

    public void paint(Graphics graphics) {
        int n;
        Insets insets = this.fc.getInsets();
        Insets insets2 = this.fc.sp.getInsets();
        this.setSize(this.fc.sp.getViewportSize().width, this.maxl * 14 + 5);
        this.fc.validate();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(this.font);
        for (int i = n = this.lc + 1 > this.maxl ? this.lc - this.maxl + 1 : 0; i <= this.lc; ++i) {
            graphics2D.drawString(this.format((String)this.lignes.elementAt(i)), 4, 13 + (i - n) * 14);
        }
        String string = this.format((String)this.lignes.elementAt(this.lc));
        int n2 = 0;
        if (Console.line != null) {
            graphics2D.drawString(Console.line, 4 + string.length() * 7, 13 + (this.lc - n) * 14);
            n2 = Console.line.length();
        }
        if (this.curseur) {
            int n3 = (string.length() + n2) * 7 + 4;
            graphics2D.drawLine(n3, 13 + (this.lc - n) * 14, n3 + 5, 13 + (this.lc - n) * 14);
        }
        if (this.top) {
            if (this.lc < this.fc.sp.getViewportSize().height / 14 - 1) {
                this.fc.sp.setScrollPosition(0, 0);
            } else {
                this.fc.sp.setScrollPosition(0, (this.lc + 1 - this.fc.sp.getViewportSize().height / 14) * 14);
            }
            this.top = false;
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Font font = new Font("Courier", 0, this.size);
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = new FontRenderContext(graphics2D.getTransform(), false, false);
        Rectangle2D rectangle2D = font.getStringBounds("AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA", fontRenderContext);
        this.width = (int)(pageFormat.getImageableWidth() / rectangle2D.getWidth() * 100.0);
        this.height = (int)(pageFormat.getImageableHeight() / (double)this.size);
        if (n * this.height > this.lc + 1) {
            return 1;
        }
        int n2 = (int)pageFormat.getImageableX();
        int n3 = (int)pageFormat.getImageableY();
        boolean bl = false;
        int n4 = n * this.height;
        int n5 = (n + 1) * this.height - 1;
        if (n5 > this.lc) {
            n5 = this.lc;
        }
        for (int i = n4; i <= n5; ++i) {
            graphics2D.drawString(this.format((String)this.lignes.elementAt(i)), n2, n3 + (i - n4 + 1) * this.size);
        }
        return 0;
    }
}

